<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Create Services</h2>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('ourService.store'), false); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                
                                <div class="col-md-12 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="title" class="form-control" value="<?php echo e(old('title'), false); ?>" required>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label for="short_description" class="form-label text-primary fw-bold">Short Description</label>
                                    <input type="text" id="short_description" name="short_description" class="form-control" value="<?php echo e(old('short_description'), false); ?>">
                                    <p id="error-message" style="color: red; display: none;">Please limit your input to 20 words or less.</p>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">Description</label>
                                    <textarea name="description" class="form-control" ><?php echo e(old('description'), false); ?></textarea>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="image" class="form-label text-primary fw-bold">Image</label>
                                    <input type="file" name="image" class="form-control">
                                </div>

                            </div>
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success ">Save</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<script>
    document.getElementById('short_description').addEventListener('input', function () {
        let inputField = this;
        let errorMessage = document.getElementById('error-message');
        let words = inputField.value.trim().split(/\s+/).filter(word => word.length > 0); // Removes empty spaces

        if (words.length > 20) {
            errorMessage.style.display = "block"; // Show error message
            inputField.style.border = "2px solid red"; // Add red border for visibility
        } else {
            errorMessage.style.display = "none"; // Hide error message
            inputField.style.border = ""; // Remove red border
        }
    });
</script>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\laragon\www\BrandedAdmin\mhmahedi\resources\views/admin/service/create.blade.php ENDPATH**/ ?>