<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\PasswordController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\TestimonialController;
use App\Http\Controllers\Admin\ProjectController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\Row2Controller;
use App\Http\Controllers\Admin\CeoMessageController;
use App\Http\Controllers\Admin\ClientsController;
use App\Http\Controllers\Admin\ConnectedController;
use App\Http\Controllers\Admin\ContactAdminController;
use App\Http\Controllers\Admin\Cv_settingController;
use App\Http\Controllers\Admin\PhotoController;
use App\Http\Controllers\Admin\PressController;
use App\Http\Controllers\Admin\StatsController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\Admin\RuralController;
use App\Http\Controllers\Admin\SchoolController;
use App\Http\Controllers\Admin\CustomServiceController;
use App\Http\Controllers\Admin\CoreKnowledgeController;
use App\Http\Controllers\Admin\MetronetController;


// Route::get('dashboard', function () {
//     return view('admin.index');
// });
Route::middleware(['admin_guest'])->group(function () {
    Route::get('/dashboard/login', [LoginController::class, 'showloginpage'])->name('dashboard.loginpage');
    Route::post('/dashboard/login', [LoginController::class, 'login'])->name('dashboard.login');
});

Route::middleware(['admin_auth'])->group(function () {
    Route::get('/dashboardhome', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/logout', [DashboardController::class, 'logout'])->name('dashboard.logout');
});

Route::middleware(['admin_auth'])->group(function () {
    Route::get('/dashboard/change-password', [PasswordController::class, 'edit'])->name('password.edit');
    Route::post('/dashboard/change-password', [PasswordController::class, 'update'])->name('password.update');
});

Route::resource('about-us', AboutController::class);
Route::resource('ourService', ServiceController::class);
Route::resource('review', TestimonialController::class);
Route::resource('projects', ProjectController::class);
Route::resource('blogs', BlogController::class);
Route::resource('row2', Row2Controller::class);
Route::resource('ceo_message', CeoMessageController::class);
Route::resource('photos', PhotoController::class);
Route::resource('videos', VideoController::class);
Route::resource('clients', ClientsController::class);
Route::resource('stats', StatsController::class);
Route::resource('cv_setting', Cv_settingController::class);
Route::resource('connected', ConnectedController::class);


Route::middleware(['admin_auth'])->group(function () {
    Route::get('/ContactSection', [ContactAdminController::class, 'index'])->name('ContactSection');
    Route::get('/data/{id}/edit', [ContactAdminController::class, 'edit'])->name('data.edit');
    Route::post('/data/{id}/update', [ContactAdminController::class, 'update'])->name('data.update');
    Route::delete('/data/{id}', [ContactAdminController::class, 'destroy'])->name('data.destroy');

    // ContactData area
    Route::get('/ContactData', [ContactAdminController::class, 'ContactData'])->name('ContactData');
    Route::get('/ContactDataCreate', [ContactAdminController::class, 'ContactDataCreate'])->name('ContactDataCreate');
    Route::post('/ContactDataCreate', [ContactAdminController::class, 'ContactDataStore'])->name('ContactDataStore');
    Route::get('/ContactData/{id}/edit', [ContactAdminController::class, 'ContactDataEdit'])->name('ContactData.edit');
    Route::post('/ContactData/{id}/update', [ContactAdminController::class, 'ContactDataUpdate'])->name('ContactData.update');
    Route::delete('/ContactData/{id}', [ContactAdminController::class, 'ContactDataDestroy'])->name('ContactData.destroy');

    // get from data 
    Route::get('/ContactFormData', [ContactAdminController::class, 'ContactFormData'])->name('ContactFormData');
    Route::delete('/ContactFormData/{id}', [ContactAdminController::class, 'destroy'])->name('Form.destroy');

    // Press area
    Route::resource('press', PressController::class);
    Route::resource('rural', RuralController::class);
    Route::resource('school', SchoolController::class);
    Route::resource('custom_service', CustomServiceController::class);
    Route::resource('coreKnowledge', CoreKnowledgeController::class);
    Route::resource('metronet', MetronetController::class);
});
