@extends('layouts.app')
@section('content')
    <div class="rts-bread-crumb-area bg_image bg-breadcrumb">
        <div class="container ptb--65">
            <div class="row">
                <div class="col-lg-12">
                    <div class="con-tent-main">
                        <div class="wrapper">
                            <span class="bg-text-stok">{{ $items->banner_title }}</span>
                            <div class="title skew-up">
                                <a href="#">{{ $items->banner_title }}</a>
                            </div>
                            <div class="slug skew-up">
                                <a href="/">HOME /</a>
                                <a class="active" href="{{ route('contact') }}">CONTACT</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- rts footer contact info area start -->
    <div class="rts-contact-info-area rts-section-gap">
        <div class="container">
            <div class="row g-24">
                @foreach ($itemsData as $item)
                    <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                        <div class="single-contact--info-wrapper">
                            <div class="thumbnail">
                                <img src="{{ asset('img/' . $item->image) }}" alt="img">
                                <div class="icon">

                                    {!! $item->icon !!}

                                </div>
                            </div>
                            <div class="content">
                                <span> {{ $item->short_title }}</span>
                                <a href="tel:+4733378901">
                                    <h5 class="title"> {{ $item->title }}</h5>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </div>
    <!-- rts footer contact info area end -->

    <!-- rts contact form area start  -->
    <div class="rts-contact-wrapper-form-area rts-section-gapBottom">
        <div class="container">
            <div class="row g-24">
                <div class="col-lg-7 col-md-12 col-sm-12 col-12">
                    <div class="form--area">
                        <div class="title-area-left">
                            <p class="pre">
                                {{ $items->from_short_title }}
                            </p>
                            <h2 class="title">
                                {{ $items->from_title }}
                            </h2>
                        </div>
                        {{-- <div id="form-messages"></div> --}}
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif


                        <form id="" action="{{ route('FormSubmit') }}" method="POST"
                            class="contact-page-form mt--30">
                            @csrf
                            <div class="name-email-wraper">
                                <input name="Contact_name" type="text" placeholder="Your Name">
                                <input name="Contact_email" type="email" placeholder="Email Address">
                            </div>
                            <textarea name="Contact_massage" placeholder="Type Your Message"></textarea>

                            <button type="submit" class="rts-btn btn-primary">Send Message</button>

                        </form>
                    </div>



                </div>
                <div class="col-lg-5 col-md-12 col-sm-12 col-12">
                    <div class="map-area-wrapper">
                        <iframe src="{{ $items->iframe }}" width="600" height="690" style="border:0;"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- rts contact form area end  -->
@endsection
