@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Services Item</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('ourService.update', $service->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="title" class="form-control" value="{{ old('title', $service->title) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="short_description" class="form-label text-primary fw-bold">Short Description</label>
                                    <textarea name="short_description" class="form-control" >{{ old('short_description', $service->short_description) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">Description</label>
                                    <textarea name="description" class="form-control" >{{ old('description', $service->description) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label">Service image</label>
                                    <input type="file" name="image" class="form-control">
                                    @if($service->image)
                                        <img src="{{ asset('img/'.$service->image) }}" alt="image" class="mt-2" width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

