


@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit school</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('school.update', $rural->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="text" class="form-control"
                                        value="{{ old('text', $rural->text) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="para" class="form-label text-primary fw-bold">Paragraph</label>
                                    <textarea name="para" class="form-control">{{ old('para', $rural->para) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">short_title</label>
                                    <textarea name="short_title" class="form-control">{{ old('short_title', $rural->short_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label"> image</label>
                                    <input type="file" name="image" class="form-control">
                                    @if ($rural->image)
                                        <img src="{{ asset('img/' . $rural->image) }}" alt="image" class="mt-2"
                                            width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
