{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Press List</title>
</head>

<body>
    <h1>Press List</h1>
    <a href="{{ route('press.create') }}">Create New Press</a>

    <table border="1">
        <tr>
            <th>Image</th>
            <th>Title</th>
            <th>Label</th>
            <th>Paragraph</th>
            <th>Actions</th>
        </tr>
        @foreach ($presses as $press)
            <tr>
                <td><img src="{{ asset('img/' . $press->image) }}" width="100"></td>
                <td>{{ $press->title }}</td>
                <td>{{ $press->label }}</td>
                <td>{{ $press->para }}</td>
                <td>
                    <a href="{{ route('press.edit', $press->id) }}">Edit</a>
                    <form action="{{ route('press.destroy', $press->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        @endforeach
    </table>
</body>

</html> --}}



@extends('admin.layouts.app')



@section('content')
    @if (session('success'))
        <div id="successAlert" class="alert alert-success fixed-bottom text-white bg-success shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div id="errorAlert" class="alert alert-danger fixed-bottom text-white bg-danger shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('error') }}
        </div>
    @endif


    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center bg-blue">
                        <h1 class="card-title" style="color:rgb(30, 255, 0);font-size:30px;">Our Rural</h1>
                        <a href="{{ route('press.create') }}" class="btn btn-success  ml-auto">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Title</th>
                                        <th>Label</th>
                                        <th>Paragraph</th>
                                        <th>img</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($presses as $index => $press)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $press->title }}</td>
                                            <td>{{ $press->label }}</td>
                                            <td>{{ $press->para }}</td>

                                            <td><img src="{{ asset('img/' . $press->image) }}" width="100"></td>


                                            <td>
                                                <a href="{{ route('press.edit', $press->id) }}"
                                                    class="btn btn-warning">Edit</a>
                                                <form action="{{ route('press.destroy', $press->id) }}" method="POST"
                                                    class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
