{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Press</title>
</head>

<body>
    <h1>Edit Press</h1>
    <form action="{{ route('press.update', $press->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <label>Image:</label>
        <input type="file" name="image"><br><br>
        <label>Title:</label>
        <input type="text" name="title" value="{{ $press->title }}" required><br><br>
        <label>Label:</label>
        <input type="text" name="label" value="{{ $press->label }}" required><br><br>
        <label>Paragraph:</label>
        <textarea name="para" required>{{ $press->para }}</textarea><br><br>
        <button type="submit">Update Press</button>
    </form>
</body>

</html> --}}


@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Rural</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('press.update', $press->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{ old('title', $press->title) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="para" class="form-label text-primary fw-bold">Paragraph</label>
                                    <textarea name="label" class="form-control">{{ old('label', $press->label) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="para" class="form-label text-primary fw-bold">Paragraph</label>
                                    <textarea name="para" class="form-control">{{ old('para', $press->para) }}</textarea>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label"> image</label>
                                    <input type="file" name="image" class="form-control">
                                    @if ($press->image)
                                        <img src="{{ asset('img/' . $press->image) }}" alt="image" class="mt-2"
                                            width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
