{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Metronet</title>
</head>

<body>
    <h1>Edit Metronet</h1>
    <form action="{{ route('metronet.update', $metronet->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <label>Image:</label>
        <input type="file" name="image"><br><br>
        <label>Title:</label>
        <input type="text" name="title" value="{{ $metronet->title }}" required><br><br>
        <label>Short Title:</label>
        <input type="text" name="short_title" value="{{ $metronet->short_title }}" required><br><br>
        <label>Paragraph:</label>
        <textarea name="para" required>{{ $metronet->para }}</textarea><br><br>
        <button type="submit">Update Metronet</button>
    </form>
</body>

</html> --}}


@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Metronet</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('metronet.update', $metronet->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{ old('title', $metronet->title) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="para" class="form-label text-primary fw-bold">Paragraph</label>
                                    <textarea name="para" class="form-control">{{ old('para', $metronet->para) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">short_title</label>
                                    <textarea name="short_title" class="form-control">{{ old('short_title', $metronet->short_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label"> image</label>
                                    <input type="file" name="image" class="form-control">
                                    @if ($metronet->image)
                                        <img src="{{ asset('img/' . $metronet->image) }}" alt="image" class="mt-2"
                                            width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
