{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Custom Service</title>
</head>

<body>
    <h1>Edit Custom Service</h1>
    <form action="{{ route('custom_service.update', $service->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <label>Image:</label>
        <input type="file" name="image"><br><br>
        <label>Text:</label>
        <input type="text" name="text" value="{{ $service->text }}" required><br><br>
        <button type="submit">Update Custom Service</button>
    </form>
</body>

</html> --}}


@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Custom Service List</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('custom_service.update', $coreKnowledge->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="text" class="form-control"
                                        value="{{ old('text', $coreKnowledge->text) }}" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="image" class="form-label"> image</label>
                                    <input type="file" name="image" class="form-control">
                                    @if ($coreKnowledge->image)
                                        <img src="{{ asset('img/' . $coreKnowledge->image) }}" alt="image" class="mt-2"
                                            width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
