{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Core Knowledge List</title>
</head>

<body>
    <h1>Core Knowledge List</h1>
    <a href="{{ route('coreKnowledge.create') }}">Create New Core Knowledge</a>

    <table border="1">
        <tr>
            <th>Image</th>
            <th>Title</th>
            <th>Short Title</th>
            <th>Paragraph</th>
            <th>Actions</th>
        </tr>
        @foreach ($coreKnowledges as $coreKnowledge)
            <tr>
                <td><img src="{{ asset('img/' . $coreKnowledge->image) }}" width="100"></td>
                <td>{{ $coreKnowledge->title }}</td>
                <td>{{ $coreKnowledge->short_title }}</td>
                <td>{{ $coreKnowledge->para }}</td>
                <td>
                    <a href="{{ route('coreKnowledge.edit', $coreKnowledge->id) }}">Edit</a>
                    <form action="{{ route('coreKnowledge.destroy', $coreKnowledge->id) }}" method="POST"
                        style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        @endforeach
    </table>
</body>

</html> --}}


@extends('admin.layouts.app')



@section('content')
    @if (session('success'))
        <div id="successAlert" class="alert alert-success fixed-bottom text-white bg-success shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div id="errorAlert" class="alert alert-danger fixed-bottom text-white bg-danger shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('error') }}
        </div>
    @endif


    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center bg-blue">
                        <h1 class="card-title" style="color:rgb(30, 255, 0);font-size:30px;">Our Core Knowledge</h1>
                        <a href="{{ route('coreKnowledge.create') }}" class="btn btn-success  ml-auto">
                            <i class="fas fa-plus"></i> Add New
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Sl</th>
                                        <th>Image</th>
                                        <th>Text</th>
                                        <th>Paragraph</th>
                                        <th>short_title</th>
                                        <th>Actions</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($coreKnowledges as $index => $rural)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $rural->text }}</td>
                                            <td>{{ $rural->para }}</td>
                                            <td>{{ $rural->short_title }}</td>
                                            <td><img src="{{ asset('img/' . $rural->image) }}" width="100"></td>


                                            <td>
                                                <a href="{{ route('coreKnowledge.edit', $rural->id) }}"
                                                    class="btn btn-warning">Edit</a>
                                                <form action="{{ route('coreKnowledge.destroy', $rural->id) }}"
                                                    method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
