{{-- <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Core Knowledge</title>
</head>
<body>
    <h1>Create New Core Knowledge</h1>
    <form action="{{ route('coreKnowledge.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <label>Image:</label>
        <input type="file" name="image" required><br><br>
        <label>Title:</label>
        <input type="text" name="title" required><br><br>
        <label>Short Title:</label>
        <input type="text" name="short_title" required><br><br>
        <label>Paragraph:</label>
        <textarea name="para" required></textarea><br><br>
        <button type="submit">Create Core Knowledge</button>
    </form>
</body>
</html> --}}



@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Create Core Knowledge</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('coreKnowledge.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">


                                <div class="col-md-12 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">Title</label>
                                    <input type="text" name="title" class="form-control" value="{{ old('title') }}"
                                        required>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">para</label>
                                    <textarea name="para" class="form-control">{{ old('para') }}</textarea>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">short_title</label>
                                    <textarea name="short_title" class="form-control">{{ old('short_title') }}</textarea>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="image" class="form-label text-primary fw-bold">Image</label>
                                    <input type="file" name="image" class="form-control">
                                </div>

                            </div>
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success ">Save</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
