@extends('admin.layouts.app')

@section('content')
<div class="container" >
    <div class="card" style="max-width: 500px; margin: 0 auto; padding: 20px;">
        <div class="card-header bg-orange text-white text-center">
            <h2 class="m-0">Change Password</h2>
        </div>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form method="POST" action="{{ route('password.update') }}">
            @csrf

            <div class="mb-3">
                <label>Current Password</label>
                <input type="password" name="current_password" class="form-control" required>
                @error('current_password') <p class="text-danger">{{ $message }}</p> @enderror
            </div>

            <div class="mb-3">
                <label>New Password</label>
                <input type="password" name="password" class="form-control" required>
                @error('password') <p class="text-danger">{{ $message }}</p> @enderror
            </div>

            <div class="mb-3">
                <label>Confirm New Password</label>
                <input type="password" name="password_confirmation" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-primary w-100">Update Password</button>
        </form>
    </div>
</div>

@endsection
