@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Contact Data Item</h2>
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="card-body">
                        <form action="{{ route('data.update', $data->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf


                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">icon</label>
                                    <input type="text" name="iframe" class="form-control"
                                        value="{{ old('iframe', $data->iframe) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">from_title</label>
                                    <textarea name="from_title" class="form-control">{{ old('from_title', $data->from_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description"
                                        class="form-label text-primary fw-bold">from_short_title</label>
                                    <textarea name="from_short_title" class="form-control">{{ old('from_short_title', $data->from_short_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">banner_title</label>
                                    <textarea name="banner_title" class="form-control">{{ old('title', $data->banner_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">image</label>

                                    @if ($data->banner_image)
                                        <img src="{{ asset('img/' . $data->banner_image) }}" alt="image" class="mt-2"
                                            width="100">
                                        <input type="file" name="banner_image" class="form-control">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
