@extends('admin.layouts.app')



@section('content')
    @if (session('success'))
        <div id="successAlert" class="alert alert-success fixed-bottom text-white bg-success shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('success') }}
        </div>
    @endif

    @if (session('error'))
        <div id="errorAlert" class="alert alert-danger fixed-bottom text-white bg-danger shadow-lg rounded p-3"
            style="width: 300px; bottom: 10px; right: 10px; position: fixed; z-index: 1050;">
            {{ session('error') }}
        </div>
    @endif


    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center bg-blue">
                        <h1 class="card-title" style="color:rgb(30, 255, 0);font-size:30px;">Contact From Data</h1>

                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Sl</th>
                                        <th>name</th>
                                        <th>email</th>
                                        <th>message</th>
                                        <th>Actions</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $index => $fromData)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $fromData->name }}</td>
                                            <td>{{ $fromData->email }}</td>
                                            <td>{{ Str::limit($fromData->massage, 50) }}</td>


                                            <td>
                                                <form action="{{ route('Form.destroy', $fromData->id) }}" method="POST"
                                                    class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
    setTimeout(function() {
        document.getElementById('successAlert')?.remove();
        document.getElementById('errorAlert')?.remove();
    }, 5000);
</script>
