@extends('admin.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white text-center">
                        <h2>Edit Contact Data Item</h2>
                    </div>
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <div class="card-body">
                        <form action="{{ route('ContactData.update', $service->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf


                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">icon</label>
                                    <input type="text" name="icon" class="form-control"
                                        value="{{ old('icon', $service->icon) }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">short_title</label>
                                    <textarea name="short_title" class="form-control">{{ old('short_title', $service->short_title) }}</textarea>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="description" class="form-label text-primary fw-bold">title</label>
                                    <textarea name="title" class="form-control">{{ old('title', $service->title) }}</textarea>
                                </div>


                                <div class="col-md-6 mb-3">
                                    <label for="title" class="form-label text-primary fw-bold">image</label>

                                    @if ($service->image)
                                        <input type="file" name="image" class="form-control" value="">
                                        <img src="{{ asset('img/' . $service->image) }}" alt="image" class="mt-2"
                                            width="100">
                                    @endif
                                </div>


                            </div>

                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-success">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
