<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('carousels', function (Blueprint $table) {
            $table->id();
            $table->string('image'); // Path to the carousel image
            $table->string('title'); // Carousel title
            $table->text('description'); // Carousel description
            $table->string('button_1_text')->nullable(); // Text for the first button
            $table->string('button_1_link')->nullable(); // Link for the first button
            $table->string('button_2_text')->nullable(); // Text for the second button
            $table->string('button_2_link')->nullable(); // Link for the second button
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('carousels');
    }
};
