<?php

namespace App\Providers;

use App\Models\CompanyInfo;
use App\Models\Connected;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    // /**
    //  * Register any application services.
    //  */
    // public function register(): void
    // {
    //     //
    // }

    // /**
    //  * Bootstrap any application services.
    //  */
    // public function boot()
    // {
    //     $company_info = CompanyInfo::get();

    //     View::share('company_info', $company_info); // Share globally in all views
    // }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Fetch company info and share it globally across all views
        $company_info = CompanyInfo::first(); // Or any query to fetch your data
        View::share('company_info', $company_info);

        $connected = Connected::first();
        view::share('connected', $connected);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}