<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use App\Models\contactFrom;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ContactController extends Controller
{
    public function contact()
    {
        $items = DB::table('_contact_area')->first();
        $itemsData = DB::table('contacts')->get();
        return view('frontend.contact.contact', compact('items', 'itemsData'));
    }



    public function formData(Request $request)
    {
        // Validate the form input
        $request->validate([
            'Contact_name' => 'required|string|max:255',
            'Contact_email' => 'required|email|max:255',
            'Contact_massage' => 'required|string',
        ]);

        try {

            $contact = new ContactFrom();
            $contact->name = $request->Contact_name;
            $contact->email = $request->Contact_email;
            $contact->massage = $request->Contact_massage;
            $contact->created_at = now();
            $contact->updated_at = now();
            $contact->save();
            return back()->with('success', 'Your message has been sent successfully!');
        } catch (\Exception $e) {
            dd($e->getMessage());
            Log::error('Error inserting contact form data: ' . $e->getMessage());
            return back()->with('error', 'There was an error while submitting your message. Please try again later.');
        }
    }
}
