<?php

namespace App\Http\Controllers;

use App\Models\TeamMember;
use App\Models\Carousel;
use App\Models\About;
use App\Models\CompanyInfo;
use App\Models\Service;
use App\Models\Testimonial;
use App\Models\Project;
use App\Models\Blog;
use App\Models\Clients;
use App\Models\Connected;
use App\Models\CoreKnowledge;
use App\Models\CustomService;
use App\Models\Cv_Setting;
use App\Models\MetroNet;
use App\Models\Photo;
use App\Models\Press;
use App\Models\Row2;
use App\Models\Rural;
use App\Models\School;
use App\Models\Stats;
use Illuminate\Http\Request;

class FrontendController extends Controller
{
    public function front()
    {

        $teamMember = TeamMember::all();
        $carousels = Carousel::first();
        $about = About::first();
        $services = Service::all();
        $testimonials = Testimonial::all();
        $project = Project::all();
        $blogs = Blog::all();
        $row2s = Row2::all();
        $clients = Clients::all();
        $photos = Photo::all();
        $stats = Stats::all();
        $cv_settings = Cv_Setting::first();
        $connected = Connected::first();


        return view('frontend.home', compact('teamMember', 'carousels', 'about', 'services', 'testimonials', 'project', 'blogs', 'row2s', 'clients', 'photos', 'stats', 'cv_settings', 'connected'));
    }

    public function metro()
    {
        $data = MetroNet::get();
        return view('frontend.business.metro', compact('data'));
    }
    public function knowledge()
    {
        $data = CoreKnowledge::get();
        return view('frontend.business.coreknowledge', compact('data'));
    }
    public function custom()
    {
        $data = CustomService::get();
        return view('frontend.project.Customer', compact('data'));
    }
    public function school()
    {
        $data = School::get();
        return view('frontend.community.rsfSchool', compact('data'));
    }
    public function rural()
    {
        $data = Rural::get();
        return view('frontend.community.ruralServices', compact('data'));
    }


    // pressReport 
    public function pressReport()
    {
        $data = Press::get();
        return view('frontend.media.pressReport', compact('data'));
    }


    // ContactPageTitle
    public function ContactPageTitle()
    {
        $company_info = CompanyInfo::first();
        return view('frontend.contact', compact('company_info'));
    }
}
