<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Metronet;
use Illuminate\Support\Facades\Storage;

class MetronetController extends Controller
{
    // Display a listing of the metronet records
    public function index()
    {
        $metronets = Metronet::all();
        return view('admin.metronet.index', compact('metronets'));
    }

    // Show the form for creating a new metronet record
    public function create()
    {
        return view('admin.metronet.create');
    }

    // Store a newly created metronet record in the database
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'short_title' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        // Handle the image upload
        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // Create the metronet record
        Metronet::create([
            'title' => $request->title,
            'image' => $image,
            'short_title' => $request->short_title,
            'para' => $request->para,
        ]);

        return redirect()->route('metronet.index')->with('success', 'Metronet created successfully!');
    }

    // Show the form for editing the specified metronet record
    public function edit($id)
    {
        $metronet = Metronet::findOrFail($id);
        return view('admin.metronet.edit', compact('metronet'));
    }

    // Update the specified metronet record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'short_title' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        $metronet = Metronet::findOrFail($id);

        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $metronet->image = $image;
        }

        // Update other fields
        $metronet->title = $request->title;
        $metronet->short_title = $request->short_title;
        $metronet->para = $request->para;

        $metronet->save();

        return redirect()->route('metronet.index')->with('success', 'Metronet updated successfully!');
    }

    // Remove the specified metronet record from the database
    public function destroy($id)
    {
        $metronet = Metronet::findOrFail($id);

        // Delete the image
        if ($metronet->image) {
            Storage::delete('public/' . $metronet->image);
        }

        $metronet->delete();

        return redirect()->route('metronet.index')->with('success', 'Metronet deleted successfully!');
    }
}
