<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Testimonial;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class TestimonialController extends Controller
{

    public function index()
    {
        $testimonials = Testimonial::all();
        return view('admin.testimonial.index', compact('testimonials'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.testimonial.create');
    }

    public function store(Request $request)
    {
        // dd($request->all());
        try {
            $request->validate([
                'name' => 'required',
                'profession' => 'required',

            ]);

            // Check if the request has an photo file
            if ($request->hasFile('photo')) {
                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);
            } else {
                $photo = null;
            }


            $model = new Testimonial();
            $model->name = $request->name;
            $model->profession = $request->profession;
            $model->description = $request->description;
            $model->photo = $photo;
            $model->save();

            return redirect()->route('review.index')->with('success', 'Testimonial created successfully');

        } catch (\Exception $e) {
            \Log::error('Error storing Testimonial: ' . $e->getMessage());
            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Testimonial $testimonial)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
       $testimonial = Testimonial::findOrFail($id);
       return view('admin.testimonial.edit', compact('testimonial'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
{
    // dd($request->all());
    try {
        $request->validate([
            'name' => 'required',
            'profession' => 'required',
        ]);

        $testimonial = Testimonial::findOrFail($id);

        if ($request->hasFile('photo')) {

            if ($testimonial->photo && file_exists(public_path('img/' . $testimonial->photo))) {
                unlink(public_path('img/' . $testimonial->photo));
            }

            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);
            $testimonial->photo = $photo;
        }

        $testimonial->name = $request->name;
        $testimonial->profession = $request->profession;
        $testimonial->description = $request->description;
        $testimonial->save();


        return redirect()->route('review.index')->with('success', 'Testimonial section updated successfully');

    } catch (\Exception $e) {
        \Log::error('Error updating Testimonial section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $testimonial = Testimonial::findOrFail($id);
        if ($testimonial->photo && file_exists(public_path('img/' . $testimonial->photo))) {
            unlink(public_path('img/' . $testimonial->photo));
        }

        $testimonial->delete();

        return redirect()->route('review.index')->with('success', 'testimonial deleted successfully.');
    }
}
