<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TeamMember;
use Illuminate\Http\Request;

class TeamMemberController extends Controller
{
    public function index()
    {
        $teamMembers = TeamMember::all(); // Get all team members
        return view('admin.team.index', compact('teamMembers'));
    }

    public function create()
    {
        return view('admin.team.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'position' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $photo = time() . '_' . $image->getClientOriginalName(); // Prevent duplicate names
            $image->move(public_path('img'), $photo); // Move to public/img directory
        } else {
            $photo = null; // Handle cases where no image is uploaded
        }

        TeamMember::create([
            'name' => $request->name,
            'position' => $request->position,
            'image' => $photo,
        ]);

        return redirect()->route('teamMember.index');
    }



    public function edit($id)
    {
        $teamMember = TeamMember::findOrFail($id);
        return view('admin.team.edit', compact('teamMember'));
    }

    // public function update(Request $request, $id)
    // {
    //     $request->validate([
    //         'name' => 'required',
    //         'position' => 'required',
    //         'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
    //     ]);

    //     $teamMember = TeamMember::findOrFail($id);

    //     $imagePath = $teamMember->image;
    //     if ($request->hasFile('image')) {
    //         // Delete old image
    //         if ($imagePath) {
    //             Storage::disk('public')->delete($imagePath);
    //         }
    //         $imagePath = $request->file('image')->store('team_images', 'public');
    //     }

    //     $teamMember->update([
    //         'name' => $request->name,
    //         'position' => $request->position,
    //         'image' => $imagePath,
    //     ]);

    //     return redirect()->route('teamMember.index');
    // }
    public function update(Request $request, TeamMember $teamMember)
    {
        $request->validate([
            'name' => 'required',
            'position' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
    
        // Handle image upload
        if ($request->hasFile('image')) {
            // Delete the old image if it exists
            if ($teamMember->image && file_exists(public_path('img/' . $teamMember->image))) {
                unlink(public_path('img/' . $teamMember->image));
            }
    
            $image = $request->file('image');
            $photo = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('img'), $photo);
        } else {
            $photo = $teamMember->image; // Keep the existing image if no new one is uploaded
        }
    
        // Update team member details
        $teamMember->update([
            'name' => $request->name,
            'position' => $request->position,
            'image' => $photo,
        ]);
    
        return redirect()->route('teamMember.index');
    }
    


    public function destroy($id)
    {
        $teamMember = TeamMember::findOrFail($id);
    
        // Delete the image from public/img if it exists
        if ($teamMember->image && file_exists(public_path('img/' . $teamMember->image))) {
            unlink(public_path('img/' . $teamMember->image));
        }
    
        // Delete the record from the database
        $teamMember->delete();
    
        return redirect()->route('teamMember.index')->with('success', 'Team member deleted successfully.');
    }
    
}
