<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Stats;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class StatsController extends Controller
{
    public function index()
    {
        $statss = Stats::all();
        return view('admin.stats.index', compact('statss'));
    }


    public function create()
    {
        return view('admin.stats.create');
    }


    public function store(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',

            ]);

            // Check if the request has an image file
            if ($request->hasFile('image')) {
                $image = time() . '_' . $request->file('image')->getClientOriginalName();
                $request->file('image')->move(public_path('img'), $image);
            } else {
                $image = null;
            }

            // Create new stats instance and assign values
            $model = new Stats();
            $model->title = $request->title;
            $model->description = $request->description;
            $model->image = $image;
            $model->save();

            return redirect()->route('stats.index')->with('success', 'stats created successfully');
        } catch (\Exception $e) {
            Log::error('Error storing stats: ' . $e->getMessage());
            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }


    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $stats = stats::findOrFail($id);
        return view('frontend.stats.show', compact('stats'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $stats = stats::find($id);
        return view('admin.stats.edit', compact('stats'));
    }


    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'title' => 'required',
            ]);

            $stats = Stats::findOrFail($id);

            if ($request->hasFile('image')) {

                if ($stats->image && file_exists(public_path('img/' . $stats->image))) {
                    unlink(public_path('img/' . $stats->image));
                }

                $image = time() . '_' . $request->file('image')->getClientOriginalName();
                $request->file('image')->move(public_path('img'), $image);
                $stats->image = $image;
            }

            $stats->title = $request->title;
            $stats->description = $request->description;
            $stats->save();


            return redirect()->route('stats.index')->with('success', 'stats section updated successfully');
        } catch (\Exception $e) {
            Log::error('Error updating stats section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $stats = Stats::findOrFail($id);
        if ($stats->image && file_exists(public_path('img/' . $stats->image))) {
            unlink(public_path('img/' . $stats->image));
        }

        $stats->delete();

        return redirect()->route('stats.index')->with('success', 'stats deleted successfully.');
    }
}