<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{

    public function index()
    {
        $services = Service::all();
        return view('admin.service.index', compact('services'));
    }


    public function create()
    {
       return view('admin.service.create');
    }


    public function store(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'short_description' => 'required',

            ]);

            // Check if the request has an image file
            if ($request->hasFile('image')) {
                $image = time() . '_' . $request->file('image')->getClientOriginalName();
                $request->file('image')->move(public_path('img'), $image);
            } else {
                $image = null;
            }

            // Create new service instance and assign values
            $model = new Service();
            $model->title = $request->title;
            $model->short_description = $request->short_description;
            $model->description = $request->description;
            $model->image = $image; // Assign the uploaded image filename
            $model->save();

            return redirect()->route('ourService.index')->with('success', 'Service created successfully');

        } catch (\Exception $e) {
            \Log::error('Error storing Service: ' . $e->getMessage());
            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }


    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $service = Service::findOrFail($id);
        return view('frontend.service.show', compact('service'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $service = Service::find($id);
        return view('admin.service.edit', compact('service'));
    }


    public function update(Request $request, $id)
{
    try {
        $request->validate([
            'title' => 'required',
            'short_description' => 'required',
        ]);

        $service = service::findOrFail($id);

        if ($request->hasFile('image')) {

            if ($service->image && file_exists(public_path('img/' . $service->image))) {
                unlink(public_path('img/' . $service->image));
            }

            $image = time() . '_' . $request->file('image')->getClientOriginalName();
            $request->file('image')->move(public_path('img'), $image);
            $service->image = $image;
        }

        $service->title = $request->title;
        $service->short_description = $request->short_description;
        $service->description = $request->description;
        $service->save();


        return redirect()->route('ourService.index')->with('success', 'Service section updated successfully');

    } catch (\Exception $e) {
        \Log::error('Error updating Service section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $service = Service::findOrFail($id);
        if ($service->image && file_exists(public_path('img/' . $service->image))) {
            unlink(public_path('img/' . $service->image));
        }

        $service->delete();

        return redirect()->route('ourService.index')->with('success', 'service deleted successfully.');
    }
}
