<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\School;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Storage;

class SchoolController extends Controller
{
    // Display a listing of the rural records
    public function index()
    {
        $rurals = School::all();
        return view('admin.school.index', compact('rurals'));
    }

    // Show the form for creating a new rural record
    public function create()
    {
        return view('admin.school.create');
    }

    // Store a newly created rural record in the database
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string|max:255',
            'short_title' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        // Handle the image upload
        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // dd(request()->all());

        // Create the rural record
        School::create([
            'image' => $image,
            'text' => $request->text,
            'short_title' => $request->short_title,
            'para' => $request->para,
        ]);

        return redirect()->route('school.index')->with('success', 'school created successfully!');
    }

    // Show the form for editing the specified rural record
    public function edit($id)
    {
        $rural = School::findOrFail($id);
        return view('admin.school.edit', compact('rural'));
    }

    // Update the specified rural record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        $rural = School::findOrFail($id);

        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $rural->image = $image;
        }

        // Update other fields
        $rural->text = $request->text;
        $rural->para = $request->para;

        $rural->save();

        return redirect()->route('school.index')->with('success', 'school updated successfully!');
    }

    // Remove the specified rural record from the database
    public function destroy($id)
    {
        $rural = School::findOrFail($id);

        // Delete the image
        if ($rural->image) {
            Storage::delete('public/' . $rural->image);
        }

        $rural->delete();

        return redirect()->route('school.index')->with('success', 'school deleted successfully!');
    }
}
