<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Rural;


use Illuminate\Support\Facades\Storage;

class RuralController extends Controller
{
    // Display a listing of the rural records
    public function index()
    {
        $rurals = Rural::all();
        return view('admin.rural.index', compact('rurals'));
    }

    // Show the form for creating a new rural record
    public function create()
    {
        return view('admin.rural.create');
    }

    // Store a newly created rural record in the database
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        // Handle the image upload
        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // dd(request()->all());

        // Create the rural record
        Rural::create([
            'image' => $image,
            'text' => $request->text,
            'para' => $request->para,
        ]);

        return redirect()->route('rural.index')->with('success', 'Rural created successfully!');
    }

    // Show the form for editing the specified rural record
    public function edit($id)
    {
        $rural = Rural::findOrFail($id);
        return view('admin.rural.edit', compact('rural'));
    }

    // Update the specified rural record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        $rural = Rural::findOrFail($id);

        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $rural->image = $image;
        }

        // Update other fields
        $rural->text = $request->text;
        $rural->para = $request->para;

        $rural->save();

        return redirect()->route('rural.index')->with('success', 'Rural updated successfully!');
    }

    // Remove the specified rural record from the database
    public function destroy($id)
    {
        $rural = Rural::findOrFail($id);

        // Delete the image
        if ($rural->image) {
            Storage::delete('public/' . $rural->image);
        }

        $rural->delete();

        return redirect()->route('rural.index')->with('success', 'Rural deleted successfully!');
    }
}
