<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use App\Models\Project;
use Illuminate\Http\Request;

class ProjectController extends Controller
{

    public function index()
    {
        $projects = Project::all();
        return view('admin.project.index', compact('projects'));
    }


    public function create()
    {
        return view('admin.project.create');
    }


    public function store(Request $request)
    {
    try {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ]);


        if ($request->hasFile('photo')) {

            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);
        } else {
            $photo = null;
        }

        $model = new Project();
        $model->title = $request->title;
        $model->description = $request->description;
        $model->photo = $photo;
        $model->save();

        // Return success response
        return redirect()->route('projects.index')->with('success', 'Project section created successfully');

    } catch (\Exception $e) {

        \Log::error('Error storing Project section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}

    /**
     * Display the specified resource.
     */
    public function show(Project $project)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $project = Project::findOrFail($id);
        return view('admin.project.edit', compact('project'));
    }


    public function update(Request $request, $id)
    {
        try {
            $request->validate([

            'title' => 'required',
            'description' => 'required',
            ]);
            $project = Project::findOrFail($id);

            if($request->hasFile('photo')) {

                if($project->photo && file_exists(public_path('img/' . $project->photo))) {
                    unlink(public_path('img/' . $project->photo));
                }

                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);

                $project->photo = $photo;
            }
            $project->title = $request->title;
            $project->description = $request->description;
            $project->save();

            return redirect()->route('projects.index')->with('success', ' Project section update succcessfully');


        } catch (\Exception $e) {
            \Log::error('Error updating Project section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $project = Project::findOrFail($id);
        if ($project->image && file_exists(public_path('img/' . $project->image))) {
            unlink(public_path('img/' . $project->image));
        }

        $project->delete();

        return redirect()->route('projects.index')->with('success', 'project deleted successfully.');
    }
}
