<?php



namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Press;
use Illuminate\Support\Facades\Storage;

class PressController extends Controller
{
    // Display a listing of the press records
    public function index()
    {
        $presses = Press::all();
        return view('admin.press.index', compact('presses'));
    }

    // Show the form for creating a new press record
    public function create()
    {
        return view('admin.press.create');
    }

    // Store a newly created press record in the database
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'required|string|max:255',
            'label' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        // Handle the image upload

        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // Create the press record
        Press::create([
            'image' => $image,
            'title' => $request->title,
            'label' => $request->label,
            'para' => $request->para,
        ]);

        return redirect()->route('press.index')->with('success', 'Press created successfully!');
    }

    // Show the form for editing the specified press record
    public function edit($id)
    {
        $press = Press::findOrFail($id);
        return view('admin.press.edit', compact('press'));
    }

    // Update the specified press record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'title' => 'required|string|max:255',
            'label' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        $press = Press::findOrFail($id);

        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $press->image = $image;
        }

        // Update other fields
        $press->title = $request->title;
        $press->label = $request->label;
        $press->para = $request->para;

        $press->save();

        return redirect()->route('press.index')->with('success', 'Press updated successfully!');
    }

    // Remove the specified press record from the database
    public function destroy($id)
    {
        $press = Press::findOrFail($id);

        // Delete the image
        if ($press->image) {
            Storage::delete('public/' . $press->image);
        }

        $press->delete();

        return redirect()->route('press.index')->with('success', 'Press deleted successfully!');
    }
}
