<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Photo;

class PhotoController extends Controller
{

    public function index()
    {
        $photos = Photo::all();
        return view('admin.photo.index', compact('photos'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.photo.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required'
            ]);
            $model = new Photo();
            $model->title = $request->title;

            if($request->hasFile('photo')) {
                $photo = time() . '-' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);
                $model->photo = $photo;
            }
            $model->save();

            return redirect()->route('photos.index')->with('success', 'Photo added successfully.');


        } catch (\Exception $e) {
            return redriect()->back()->with('error', 'something went worng: ' . $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit( $id)
    {
        $photo = Photo::find($id);
        return view('admin.photo.edit',compact('photo'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {

        try {
            $request->validate([
                'title' => 'required',
            ]);

                $photo = Photo::findOrFail($id);

                $photo->title = $request->title;

                if ($request->hasFile('photo')) {

                    if ($photo->photo && file_exists(public_path('img/' . $photo->photo))) {
                        unlink(public_path('img/' . $photo->photo));
                    }

                    $filename = time() . '_' . $request->file('photo')->getClientOriginalName();
                    $request->file('photo')->move(public_path('img'), $filename);

                    $photo->photo = $filename;
                }
                $photo->save();

                return redirect()->route('photos.index')->with('success', 'Photos Updated successfully ');

            } catch (\Exception $e) {
                return redirect()->back()->with('error', 'Something went wrong: ' . $e->getMessage());
            }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $photo = Photo::findOrFail($id);

        if($photo->photo && file_exists(public_path('img/' . $photo->photo))) {
            unlink(public_path('img/' . $photo->photo));
        }

        $photo->delete();

        return redirect()->route('photos.index')->with('success', 'Photo deleted successfully');
    }
}
