<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class PasswordController extends Controller
{
   public function edit()
   {
     return view('admin.auth.password');
   }

   public function update(Request $request)
   {
    $request->validate([
        'current_password' => 'required',
        'password' => 'required',
    ]);

    // Check if the current password is correct
    if (!Hash::check($request->current_password, Auth::user()->password)) {
        return back()->withErrors(['current_password' => 'Current password is incorrect']);
    }

    // Update the password
    Auth::user()->update([
        'password' => Hash::make($request->password),
    ]);

    return redirect()->route('dashboard')->with('success', 'Password updated successfully.');
}
   }

