<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Cv_Setting;
use Illuminate\Http\Request;

class Cv_settingController extends Controller
{
    public function index()
    {
        $cv_settings = Cv_Setting::all();
        return view('admin.cv_settings.index', compact('cv_settings'));
    }

    public function create()
    {
        return view('admin.cv_settings.create');
    }

    // Store new site setting
    public function store(Request $request)
    {
        $request->validate([
            'cv_file' => 'nullable|mimes:pdf,doc,docx|max:2048',
        ]);

        $setting = new Cv_Setting();

        if ($request->hasFile('cv_file')) {
            $file = $request->file('cv_file');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('uploads/cv'), $filename);
            $setting->cv_file = $filename;
        }

        $setting->save();

        return redirect()->route('cv_setting.index')->with('success', 'CV uploaded successfully.');
    }

    public function edit($id)
    {
        $setting = Cv_Setting::findOrFail($id);
        return view('admin.cv_settings.edit', compact('setting'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'cv_file' => 'nullable|mimes:pdf,doc,docx|max:2048',
        ]);

        $setting = Cv_Setting::findOrFail($id);

        if ($request->hasFile('cv_file')) {
            // Delete old file
            if ($setting->cv_file && file_exists(public_path('uploads/cv/' . $setting->cv_file))) {
                unlink(public_path('uploads/cv/' . $setting->cv_file));
            }

            $file = $request->file('cv_file');
            $filename = time() . '_' . $file->getClientOriginalName();
            $file->move(public_path('uploads/cv'), $filename);
            $setting->cv_file = $filename;
        }

        $setting->save();

        return redirect()->route('cv_setting.index')->with('success', 'CV file updated.');
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $setting = Cv_Setting::findOrFail($id);

        if ($setting->cv_file && file_exists(public_path('uploads/cv/' . $setting->cv_file))) {
            unlink(public_path('uploads/cv/' . $setting->cv_file));
        }

        $setting->delete();

        return redirect()->route('cv_setting.index')->with('success', 'CV deleted.');
    }
}