<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomService;
use Illuminate\Support\Facades\Storage;

class CustomServiceController extends Controller
{
    // Display a listing of the custom service records
    public function index()
    {
        $services = CustomService::all();
        return view('admin.custom_service.index', compact('services'));
    }

    // Show the form for creating a new custom service record
    public function create()
    {
        return view('admin.custom_service.create');
    }

    // Store a newly created custom service record in the database
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string',
        ]);

        // Handle the image upload
        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // Create the custom service record
        CustomService::create([
            'image' => $image,
            'text' => $request->text,
        ]);

        return redirect()->route('custom_service.index')->with('success', 'Custom Service created successfully!');
    }

    // Show the form for editing the specified custom service record
    public function edit($id)
    {
        $service = CustomService::findOrFail($id);
        return view('admin.custom_service.edit', compact('service'));
    }

    // Update the specified custom service record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'text' => 'required|string',
        ]);

        $service = CustomService::findOrFail($id);

        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $service->image = $image;
        }


        // Update the other fields
        $service->text = $request->text;

        $service->save();

        return redirect()->route('custom_service.index')->with('success', 'Custom Service updated successfully!');
    }

    // Remove the specified custom service record from the database
    public function destroy($id)
    {
        $service = CustomService::findOrFail($id);

        // Delete the image
        if ($service->image) {
            Storage::delete('public/' . $service->image);
        }

        $service->delete();

        return redirect()->route('custom_service.index')->with('success', 'Custom Service deleted successfully!');
    }
}
