<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\CoreKnowledge;
use Illuminate\Support\Facades\Storage;

class CoreKnowledgeController extends Controller
{
    // Display a listing of the core knowledge records
    public function index()
    {
        $coreKnowledges = CoreKnowledge::all();
        return view('admin.coreKnowledge.index', compact('coreKnowledges'));
    }

    // Show the form for creating a new core knowledge record
    public function create()
    {
        return view('admin.coreKnowledge.create');
    }

    // Store a newly created core knowledge record in the database
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'short_title' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        // Handle the image upload
        if ($request->hasFile('image')) {

            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
        } else {

            $image = null;
        }

        // Create the core knowledge record
        CoreKnowledge::create([
            'title' => $request->title,
            'image' => $image,
            'short_title' => $request->short_title,
            'para' => $request->para,
        ]);

        return redirect()->route('coreKnowledge.index')->with('success', 'Core Knowledge created successfully!');
    }

    // Show the form for editing the specified core knowledge record
    public function edit($id)
    {
        $coreKnowledge = CoreKnowledge::findOrFail($id);
        return view('admin.coreKnowledge.edit', compact('coreKnowledge'));
    }

    // Update the specified core knowledge record in the database
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'short_title' => 'required|string|max:255',
            'para' => 'required|string',
        ]);

        $coreKnowledge = CoreKnowledge::findOrFail($id);

        // If a new image is uploaded, handle it
        // If a new image is uploaded, handle it
        if ($request->hasFile('image')) {
            // Store new image
            $image = time() . '_' . $request->file('image')->getClientOriginalName();

            $request->file('image')->move(public_path('img'), $image);
            $coreKnowledge->image = $image;
        }


        // Update other fields
        $coreKnowledge->title = $request->title;
        $coreKnowledge->short_title = $request->short_title;
        $coreKnowledge->para = $request->para;

        $coreKnowledge->save();

        return redirect()->route('coreKnowledge.index')->with('success', 'Core Knowledge updated successfully!');
    }

    public function destroy($id)
    {
        $coreKnowledge = CoreKnowledge::findOrFail($id);

        // Delete the image
        if ($coreKnowledge->image) {
            Storage::delete('public/' . $coreKnowledge->image);
        }

        $coreKnowledge->delete();

        return redirect()->route('coreKnowledge.index')->with('success', 'Core Knowledge deleted successfully!');
    }
}
