<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\contactFrom;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class ContactAdminController extends Controller
{

    public function index()
    {
        $data = DB::table('_contact_area')->get();
        return view('admin.ContactPage.index', compact('data'));
    }
    public function edit($id)
    {
        $data = DB::table('_contact_area')->where('id', $id)->first();
        if (!$data) {
            abort(404, 'Data not found');
        }
        return view('admin.ContactPage.edit', compact('data'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'iframe' => 'required',
            'from_title' => 'required',
            'from_short_title' => 'required',
            'banner_title' => 'required',
        ]);

        try {

            if ($request->hasFile('banner_image')) {

                $image = time() . '_' . $request->file('banner_image')->getClientOriginalName();

                $request->file('banner_image')->move(public_path('img'), $image);
            } else {

                $image = null;
            }


            $updateData = [
                'iframe' => $request->iframe,
                'from_title' => $request->from_title,
                'from_short_title' => $request->from_short_title,
                'banner_title' => $request->banner_title,
            ];


            if ($image) {
                $updateData['banner_image'] = $image;
            }


            $data = DB::table('_contact_area')->where('id', $id)->update($updateData);


            if ($data) {
                return redirect()->route('ContactSection')->with('success', 'Contact section updated successfully.');
            } else {
                return back()->with('error', 'Failed to update contact section.');
            }
        } catch (\Exception $e) {

            Log::error('Error updating contact section: ' . $e->getMessage());

            return back()->with('error', 'There was an error while updating the contact section. Please try again later.');
        }
    }






    // ContactData area 

    public function ContactDataCreate()
    {
        return view('admin.ContactPage.ContactDataCreate');
    }

    public function ContactDataStore(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'icon' => 'required',
            'image' => 'required',
            'short_title' => 'required',
            'title' => 'required',
        ]);


        if ($request->hasFile('image')) {
            $image = time() . '_' . $request->file('image')->getClientOriginalName();
            $request->file('image')->move(public_path('img'), $image);
        } else {
            $image = null;
        }

        $data = DB::table('contacts')->insert([
            'icon' => $request->icon,
            'image' =>  $image,
            'short_title' => $request->short_title,
            'title' => $request->title,
        ]);

        if ($data) {
            return redirect()->route('ContactData')->with('success', 'Contact data added successfully.');
        } else {
            return back()->with('error', 'Failed to add contact data.');
        }
    }


    public function ContactData()
    {
        $ContactData = DB::table('contacts')->get();
        return view('admin.ContactPage.ContactData', compact('ContactData'));
    }

    public function ContactDataEdit($id)
    {

        $service = DB::table('contacts')->where('id', $id)->first();
        if (!$service) {
            abort(404, 'Service not found');
        }
        return view('admin.ContactPage.ContactDataEdit', compact('service'));
    }

    public function ContactDataUpdate(Request $request, $id)
    {

        $request->validate([
            'icon' => 'required',
            'short_title' => 'required',
            'title' => 'required',
        ]);

        try {


            if ($request->hasFile('image')) {

                $image = time() . '_' . $request->file('image')->getClientOriginalName();

                $request->file('image')->move(public_path('img'), $image);
            } else {
                // If no new image is uploaded, retain the current image
                $image = null;
            }

            // Prepare data for the update query
            $data = [
                'icon' => $request->icon,
                'short_title' => $request->short_title,
                'title' => $request->title,
            ];

            // If a new image is uploaded, include it in the update data
            if ($image) {
                $data['image'] = $image;
            }

            // Perform the database update
            $update = DB::table('contacts')->where('id', $id)->update($data);

            // Check if the update was successful
            if ($update) {
                return redirect()->route('ContactData')->with('success', 'Contact data updated successfully.');
            } else {
                return back()->with('error', 'Failed to update contact data.');
            }
        } catch (\Exception $e) {
            // Log any errors and return a friendly error message
            Log::error('Error updating contact data: ' . $e->getMessage());
            return back()->with('error', 'There was an error while updating the contact data. Please try again later.');
        }
    }



    public function ContactDataDestroy($id)
    {
        $data = DB::table('contacts')->where('id', $id)->delete();
        if ($data) {
            return back()->with('success', 'Contact data deleted successfully.');
        } else {
            return back()->with('error', 'Contact data not found.');
        }
    }








    // ContactFormData area

    public function ContactFormData()
    {
        $data = contactFrom::get();
        return view('admin.ContactPage.ContactFormData', compact('data'));
    }

    public function destroy($id)
    {
        $data = contactFrom::find($id);
        if ($data) {
            $data->delete();
            return back()->with('success', 'Contact form data deleted successfully.');
        } else {
            return back()->with('error', 'Contact form data not found.');
        }
    }
}
