<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Connected;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ConnectedController extends Controller
{

    public function index()
    {
        $connected = Connected::first();
        return view('admin.connected.index', compact('connected'));
    }


    public function create()
    {
        return view('admin.connected.create');
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
            ]);

            $model = new Connected();
            $model->title = $request->title;
            $model->description = $request->description;
            // $connected->photo = $photo;
            $model->save();

            // Return success response
            return redirect()->route('connected.index')->with('success', 'connected section created successfully');
        } catch (\Exception $e) {

            Log::error('Error storing connected section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(connected $connected)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $connected = Connected::find($id);
        return view('admin.connected.edit', compact('connected'));
    }


    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'title' => 'required',

            ]);

            $connected = Connected::findOrFail($id);


            $connected->title = $request->title;
            $connected->description = $request->description;
            $connected->save();


            return redirect()->route('connected.index')->with('success', 'connected section updated successfully');
        } catch (\Exception $e) {
            Log::error('Error updating connected section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $connected = Connected::findOrFail($id);

        $connected->delete();

        return redirect()->route('connected-us.index')->with('success', 'connected deleted successfully.');
    }
}
