<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CompanyInfo;
use Illuminate\Http\Request;

class CompanyInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $companies = CompanyInfo::all();
        return view('admin.company_info.index', compact('companies'));
    }


    public function create()
    {
        return view('admin.company_info.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'nullable|email',
            'phone' => 'nullable|string',
            'address' => 'nullable|string',
            'description' => 'nullable|string',
            'logo' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($request->hasFile('logo')) {
            $logo = time() . '_' . $request->file('logo')->getClientOriginalName();
            $request->file('logo')->move(public_path('img'), $logo);
        } else {
            $logo = null;
        }

        CompanyInfo::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'description' => $request->description,
            'logo' => $logo,
        ]);

        return redirect()->route('company_info.index')->with('success', 'Company Info added successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(CompanyInfo $companyInfo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $companyInfo = CompanyInfo::where('id', $id)->firstOrFail();
        return view('admin.company_info.edit', compact('companyInfo'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, CompanyInfo $companyInfo)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'nullable|email',
            'phone' => 'nullable|string',
            'address' => 'nullable|string',
            'description' => 'nullable|string',
            'logo' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $company_info = CompanyInfo::first();
        if (!$company_info) {
            $company_info = new CompanyInfo();
        }

        if ($request->hasFile('logo')) {
            $logoName = time() . '.' . $request->logo->extension();
            $request->logo->move(public_path('img'), $logoName);
            $company_info->logo = $logoName;
        }

        $company_info->name = $request->name;
        $company_info->phone = $request->phone;
        $company_info->email = $request->email;
        $company_info->address = $request->address;
        $company_info->description = $request->description;

        $company_info->save();

        return redirect()->back()->with('success', 'Company Info Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $company_info = CompanyInfo::findOrFail($id);

        // Delete the image from public/img if it exists
        if ($company_info->image && file_exists(public_path('img/' . $company_info->image))) {
            unlink(public_path('img/' . $company_info->image));
        }

        // Delete the record from the database
        $company_info->delete();

        return redirect()->route('company_info.index')->with('success', 'Comapny Info  deleted successfully.');
    }
}
