<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Clients;
use Illuminate\Http\Request;

class ClientsController extends Controller
{

    public function index()
    {
        $clients = Clients::all();
        return view('admin.client.index', compact('clients'));
    }


    public function create()
    {
        return view('admin.client.create');
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $request->validate([
                'photo' => 'required',

            ]);


            if ($request->hasFile('photo')) {

                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);
            } else {
                $photo = null;
            }

            $model = new Clients();
            $model->title = $request->title;
            $model->photo = $photo;
            $model->save();

            // Return success response
            return redirect()->route('clients.index')->with('success', 'Clients section created successfully');
        } catch (\Exception $e) {

            \Log::error('Error storing About section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
   public function edit($id)
    {
        $client = Clients::find($id);
        return view('admin.client.edit', compact('client'));
    }


    public function update(Request $request, $id)
{
    try {
        $request->validate([
            'photo' => 'required',

        ]);

        $client = Clients::findOrFail($id);

        if ($request->hasFile('photo')) {

            if ($client->photo && file_exists(public_path('img/' . $client->photo))) {
                unlink(public_path('img/' . $client->photo));
            }

            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);

            $client->photo = $photo;
        }

        $client->title = $request->title;
        $client->save();


        return redirect()->route('clients.index')->with('success', 'client section updated successfully');

    } catch (\Exception $e) {
        \Log::error('Error updating client section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $client = client::findOrFail($id);
        if ($client->photo && file_exists(public_path('img/' . $client->photo))) {
            unlink(public_path('img/' . $client->photo));
        }

        $client->delete();

        return redirect()->route('client.index')->with('success', 'client deleted successfully.');
    }
}
