<?php

namespace App\Http\Controllers\Admin;

use App\Models\Ceo_message;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CeoMessageController extends Controller
{

    public function index()
    {
        $ceo_messages =Ceo_message::all();
        return view('admin.ceo_message.index', compact('ceo_messages'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.ceo_message.create');
    }

    public function store(Request $request)
    {
        // dd($request->all());
        try {
            $request->validate([
                'title' => 'required',

            ]);


            if ($request->hasFile('photo')) {

                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);
            } else {
                $photo = null;
            }

            $model = new Ceo_message();
            $model->title = $request->title;
            $model->name = $request->name;
            $model->description = $request->description;
            $model->photo = $photo;
            $model->save();

            return redirect()->route('ceo_message.index')->with('success', 'Ceo Message created successfully');

        } catch (\Exception $e) {
            \Log::error('Error storing Ceo Message section: ' . $e->getMessage());

                return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $ceo_message = Ceo_message::find($id);
        return view('admin.ceo_message.edit', compact('ceo_message'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,  $id)
    {
        try {
            $request->validate([
                'title' => 'required',

            ]);

            $ceo_message = Ceo_message::findOrFail($id);

            if ($request->hasFile('photo')) {

                if ($ceo_message->photo && file_exists(public_path('img/' . $ceo_message->photo))) {
                    unlink(public_path('img/' . $ceo_message->photo));
                }

                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);

                $ceo_message->photo = $photo;
            }

            $ceo_message->title = $request->title;
            $ceo_message->name = $request->name;
            $ceo_message->description = $request->description;
            $ceo_message->save();


            return redirect()->route('ceo_message.index')->with('success', 'ceo_message section updated successfully');

        } catch (\Exception $e) {
            \Log::error('Error updating About section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $ceo_message = Ceo_message::findOrFail($id);

        if($ceo_message->photo && file_exists(public_path('img/' . $ceo_message->photo))) {
            unlink(public_path('img/' . $ceo_message->photo));
        }

        $ceo_message->delete();

        return redirect()->route('ceo_message.index')->with('success', 'Ceo message deleted successfully');
    }
}
