<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Carousel;
use Illuminate\Http\Request;

class CarouselController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $carousels = Carousel::all();
        return view('admin.carousel.index', compact('carousels'));
    }

    public function create()
    {
        return view('admin.carousel.create');
    }


    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required',
            'title' => 'required',
            'description' => 'required|string',

        ]);

        if ($request->hasFile('image')) {
            $image = time() . '_' . $request->file('image')->getClientOriginalName();
            $request->file('image')->move(public_path('img'), $image);
        } else {
            $image = null;
        }

        Carousel::create([
            'image' => $image,
            'title' => $request->title,
            'description' => $request->description,
            'button_1_text' => $request->button_1_text,
            'button_1_link' => $request->button_1_link,
            'button_2_text' => $request->button_2_text,
            'button_2_link' => $request->button_2_link,
        ]);

        return redirect()->route('carousels.index')->with('success', 'Carousel item created successfully.');
    }


    /**
     * Display the specified resource.
     */
    public function show(Carousel $carousel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $carousel = Carousel::find($id);
        return view('admin.carousel.edit', compact('carousel'));
    }


    public function update(Request $request, $id)
{
    $carousel = Carousel::findOrFail($id);
    $request->validate([
        'title' => 'required|string|max:255',
        'description' => 'required|string|max:1000',
        'image' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',

    ]);

    $carousel->title = $request->title;
    $carousel->description = $request->description;

    if ($request->hasFile('image')) {
        $imageName = time() . '.' . $request->image->extension();
        $request->image->move(public_path('img'), $imageName);
        $carousel->image = $imageName;
    }

    $carousel->button_1_text = $request->button_1_text;
    $carousel->button_1_link = $request->button_1_link;
    $carousel->button_2_text = $request->button_2_text;
    $carousel->button_2_link = $request->button_2_link;

    $carousel->save();

    return redirect()->route('carousels.index')->with('success', 'Carousel item updated successfully.');
}
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
       $carousel = Carousel::findOrFail($id);

       if ($carousel->image && file_exists(public_path('img/' . $carousel->image))) {
        unlink(public_path('img/' . $carousel->image));
    }

    $carousel->delete();

    return redirect()->route('carousels.index')->with('success', 'Carousels deleted successfully.');
    }
}
