<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use App\Models\Blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{

    public function index()
    {
       $blogs = Blog::all();

       return view('admin.blog.index', compact('blogs'));
    }


    public function create()
    {
        return view('admin.blog.create');
    }


    public function store(Request $request)
    {
        //
        // dd($request->all());
        try {
        $request->validate([
            'date' => 'required',
            'title' => 'required',

        ]);

        if ($request->hasFile('photo')) {
            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);
        } else {
            $photo = null;
        }

            $model = new Blog();
            $model->date = $request->date;
            $model->name = $request->name;
            $model->title = $request->title;
            $model->description = $request->description;
            $model->photo = $photo;
           $model->save();

           return redirect()->route('blogs.index')->with('success', 'Blogs section created successfully');
        } catch (Exception $e) {
            return redirect()->back()->with('error', 'An error occurred: ' . $e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $blog = Blog::findOrFail($id);
        return view('frontend.blog.show', compact('blog'));
    }


    public function edit($id)
    {
       $blog = Blog::findOrFail($id);
       return view('admin.blog.edit', compact('blog'));
    }

    public function update(Request $request, $id)
    {
        try {
            $request->validate([
            'date' => 'required',
            'title' => 'required',

            ]);
            $blog = Blog::findOrFail($id);

            if($request->hasFile('photo')) {

                if($blog->photo && file_exists(public_path('img/' . $blog->photo))) {
                    unlink(public_path('img/' . $blog->photo));
                }

                $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
                $request->file('photo')->move(public_path('img'), $photo);

                $blog->photo = $photo;
            }

            $blog->date = $request->date;
            $blog->name = $request->name;
            $blog->title = $request->title;
            $blog->description = $request->description;
            $blog->save();

            return redirect()->route('blogs.index')->with('success', ' Blog section update succcessfully');


        } catch (\Exception $e) {
            \Log::error('Error updating Project section: ' . $e->getMessage());

            return back()->with('error', 'Something went wrong. Please try again.');
        }
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $blogs = Blog::findOrFail($id);
        if ($blogs->image && file_exists(public_path('img/' . $blogs->image))) {
            unlink(public_path('img/' . $blogs->image));
        }

        $blogs->delete();

        return redirect()->route('blogs.index')->with('success', 'blogs deleted successfully.');
    }
}
