<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use App\Models\About;
use Illuminate\Http\Request;

class AboutController extends Controller
{

    public function index()
    {
        $abouts = About::all();
        return view('admin.about.index', compact('abouts'));
    }


    public function create()
    {
        return view('admin.about.create');
    }

    public function store(Request $request)
    {
    try {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ]);


        if ($request->hasFile('photo')) {

            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);
        } else {
            $photo = null;
        }

        $about = new About();
        $about->title = $request->title;
        $about->description = $request->description;
        $about->photo = $photo;
        $about->save();

        // Return success response
        return redirect()->route('about-us.index')->with('success', 'About section created successfully');

    } catch (\Exception $e) {

        \Log::error('Error storing About section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}


    /**
     * Display the specified resource.
     */
    public function show(About $about)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $about = About::find($id);
        return view('admin.about.edit', compact('about'));
    }


    public function update(Request $request, $id)
{
    try {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        $about = About::findOrFail($id);

        if ($request->hasFile('photo')) {

            if ($about->photo && file_exists(public_path('img/' . $about->photo))) {
                unlink(public_path('img/' . $about->photo));
            }

            $photo = time() . '_' . $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('img'), $photo);

            $about->photo = $photo;
        }

        $about->title = $request->title;
        $about->description = $request->description;
        $about->save();


        return redirect()->route('about-us.index')->with('success', 'About section updated successfully');

    } catch (\Exception $e) {
        \Log::error('Error updating About section: ' . $e->getMessage());

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $about = About::findOrFail($id);
        if ($about->photo && file_exists(public_path('img/' . $about->photo))) {
            unlink(public_path('img/' . $about->photo));
        }

        $about->delete();

        return redirect()->route('about-us.index')->with('success', 'about deleted successfully.');
    }
}
